<?php
require_once 'config.php';

if(!isLoggedIn()) {
    header("Location: login.php");
    exit();
}

if(!isActiveUser()) {
    header("Location: activate.php");
    exit();
}

$user_id = $_SESSION['user_id'];
$user = $conn->query("SELECT * FROM users WHERE id = $user_id")->fetch_assoc();

// Get admin settings for referral percentage
$settings = getSettings();
$referral_percentage = $settings['referral_percentage'];

// Get referral statistics
$stats = $conn->query("
    SELECT 
        COUNT(*) as total_referrals,
        SUM(CASE WHEN status = 'paid' THEN 1 ELSE 0 END) as active_referrals,
        SUM(CASE WHEN status = 'pending' THEN 1 ELSE 0 END) as pending_referrals,
        COALESCE(SUM(bonus_amount), 0) as total_earnings
    FROM referrals 
    WHERE referrer_id = $user_id
")->fetch_assoc();

// Get referral history with pagination
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$per_page = 10;
$offset = ($page - 1) * $per_page;

$referrals_query = "
    SELECT r.*, u.username, u.email, u.is_active, u.created_at as user_created
    FROM referrals r
    JOIN users u ON r.referred_id = u.id
    WHERE r.referrer_id = $user_id
    ORDER BY r.created_at DESC
    LIMIT $per_page OFFSET $offset
";
$referrals_result = $conn->query($referrals_query);

// Get total referrals count
$total_referrals_count = $conn->query("SELECT COUNT(*) as count FROM referrals WHERE referrer_id = $user_id")->fetch_assoc()['count'];
$total_pages = ceil($total_referrals_count / $per_page);

// Get recent referral earnings
$recent_earnings = $conn->query("
    SELECT * FROM transactions 
    WHERE user_id = $user_id AND type = 'referral_bonus' 
    ORDER BY created_at DESC 
    LIMIT 5
");

// Get leaderboard
$leaderboard = $conn->query("
    SELECT u.username, COUNT(r.id) as referral_count, SUM(r.bonus_amount) as total_earnings
    FROM users u
    LEFT JOIN referrals r ON u.id = r.referrer_id AND r.status = 'paid'
    WHERE u.is_active = TRUE
    GROUP BY u.id
    ORDER BY referral_count DESC, total_earnings DESC
    LIMIT 10
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Referrals - Project Sale</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <style>
        .referral-card {
            transition: all 0.3s ease;
        }
        .referral-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.1);
        }
        .stat-card {
            transition: all 0.3s ease;
        }
        .stat-card:hover {
            transform: translateY(-5px);
        }
        .leaderboard-item {
            transition: all 0.2s ease;
        }
        .leaderboard-item:hover {
            background-color: #f9fafb;
        }
        .rank-badge {
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            font-weight: bold;
        }
        .rank-1 { background: linear-gradient(135deg, #FFD700, #FFA500); color: white; }
        .rank-2 { background: linear-gradient(135deg, #C0C0C0, #A0A0A0); color: white; }
        .rank-3 { background: linear-gradient(135deg, #CD7F32, #A0522D); color: white; }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Include Header -->
    <?php include 'includes/header.php'; ?>
    
    <div class="flex min-h-screen">
        <!-- Sidebar -->
        <div class="hidden md:block w-64 bg-white shadow-lg">
            <?php include 'includes/sidebar.php'; ?>
        </div>
        
        <!-- Main Content -->
        <div class="flex-1 p-6">
            <!-- Breadcrumb -->
            <div class="mb-6">
                <nav class="flex" aria-label="Breadcrumb">
                    <ol class="inline-flex items-center space-x-1 md:space-x-3">
                        <li class="inline-flex items-center">
                            <a href="index.php" class="inline-flex items-center text-sm text-gray-700 hover:text-blue-600">
                                <i class="fas fa-home mr-2"></i> Home
                            </a>
                        </li>
                        <li>
                            <div class="flex items-center">
                                <i class="fas fa-chevron-right text-gray-400 text-xs"></i>
                                <a href="dashboard.php" class="ml-1 text-sm text-gray-700 hover:text-blue-600 md:ml-2">Dashboard</a>
                            </div>
                        </li>
                        <li aria-current="page">
                            <div class="flex items-center">
                                <i class="fas fa-chevron-right text-gray-400 text-xs"></i>
                                <span class="ml-1 text-sm text-gray-500 md:ml-2 font-medium">Referrals</span>
                            </div>
                        </li>
                    </ol>
                </nav>
            </div>
            
            <!-- Header -->
            <div class="mb-8">
                <h1 class="text-3xl font-bold text-gray-800 mb-2">
                    <i class="fas fa-users mr-2"></i> Referral Program
                </h1>
                <p class="text-gray-600">Invite friends and earn commissions</p>
            </div>
            
            <!-- Referral Stats -->
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
                <div class="stat-card bg-gradient-to-r from-blue-500 to-indigo-600 rounded-xl shadow-lg p-6 text-white animate__animated animate__fadeInUp">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-blue-100 text-sm">Total Referrals</p>
                            <h3 class="text-3xl font-bold mt-2"><?php echo $stats['total_referrals']; ?></h3>
                        </div>
                        <div class="w-14 h-14 bg-white/20 rounded-full flex items-center justify-center">
                            <i class="fas fa-user-friends text-2xl"></i>
                        </div>
                    </div>
                </div>
                
                <div class="stat-card bg-gradient-to-r from-green-500 to-emerald-600 rounded-xl shadow-lg p-6 text-white animate__animated animate__fadeInUp" style="animation-delay: 0.1s">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-green-100 text-sm">Active Referrals</p>
                            <h3 class="text-3xl font-bold mt-2"><?php echo $stats['active_referrals']; ?></h3>
                        </div>
                        <div class="w-14 h-14 bg-white/20 rounded-full flex items-center justify-center">
                            <i class="fas fa-user-check text-2xl"></i>
                        </div>
                    </div>
                </div>
                
                <div class="stat-card bg-gradient-to-r from-yellow-500 to-orange-600 rounded-xl shadow-lg p-6 text-white animate__animated animate__fadeInUp" style="animation-delay: 0.2s">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-yellow-100 text-sm">Pending Referrals</p>
                            <h3 class="text-3xl font-bold mt-2"><?php echo $stats['pending_referrals']; ?></h3>
                        </div>
                        <div class="w-14 h-14 bg-white/20 rounded-full flex items-center justify-center">
                            <i class="fas fa-clock text-2xl"></i>
                        </div>
                    </div>
                </div>
                
                <div class="stat-card bg-gradient-to-r from-purple-500 to-pink-600 rounded-xl shadow-lg p-6 text-white animate__animated animate__fadeInUp" style="animation-delay: 0.3s">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-purple-100 text-sm">Total Earnings</p>
                            <h3 class="text-3xl font-bold mt-2">৳<?php echo number_format($stats['total_earnings'], 2); ?></h3>
                        </div>
                        <div class="w-14 h-14 bg-white/20 rounded-full flex items-center justify-center">
                            <i class="fas fa-money-bill-wave text-2xl"></i>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Left Column - Referral Tools -->
                <div class="lg:col-span-2 space-y-8">
                    <!-- Referral Link Card -->
                    <div class="bg-white rounded-xl shadow-lg overflow-hidden animate__animated animate__fadeInLeft">
                        <div class="bg-gradient-to-r from-blue-500 to-indigo-600 px-6 py-4">
                            <h3 class="text-xl font-bold text-white">
                                <i class="fas fa-link mr-2"></i> Your Referral Link
                            </h3>
                        </div>
                        <div class="p-6">
                            <div class="mb-6">
                                <p class="text-gray-600 mb-4">
                                    Share your unique referral link with friends. When they join using your link and activate their account, 
                                    you'll earn <span class="font-bold text-green-600"><?php echo $referral_percentage; ?>%</span> of their activation fee.
                                </p>
                                
                                <div class="flex items-center mb-4">
                                    <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mr-4">
                                        <i class="fas fa-percentage text-blue-600 text-xl"></i>
                                    </div>
                                    <div>
                                        <h4 class="font-bold text-gray-800">Commission Rate: <?php echo $referral_percentage; ?>%</h4>
                                        <p class="text-gray-600 text-sm">Earn <?php echo $referral_percentage; ?>% of each referral's activation fee</p>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Referral Link -->
                            <div class="mb-6">
                                <label class="block text-gray-700 text-sm font-bold mb-2">
                                    Your Referral Link
                                </label>
                                <div class="flex">
                                    <input type="text" 
                                           id="referralLink" 
                                           value="<?php echo SITE_URL; ?>/register.php?referral=<?php echo $user['referral_code']; ?>" 
                                           readonly 
                                           class="flex-1 px-4 py-3 border border-gray-300 rounded-l-lg bg-gray-50 font-mono text-sm">
                                    <button onclick="copyReferralLink()" 
                                            class="bg-gradient-to-r from-blue-600 to-indigo-600 text-white font-bold px-6 rounded-r-lg hover:opacity-90 transition duration-300">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                            
                            <!-- Referral Code -->
                            <div class="mb-6">
                                <label class="block text-gray-700 text-sm font-bold mb-2">
                                    Your Referral Code
                                </label>
                                <div class="flex">
                                    <input type="text" 
                                           id="referralCode" 
                                           value="<?php echo $user['referral_code']; ?>" 
                                           readonly 
                                           class="flex-1 px-4 py-3 border border-gray-300 rounded-l-lg bg-gray-50 font-mono text-center text-lg font-bold">
                                    <button onclick="copyReferralCode()" 
                                            class="bg-gradient-to-r from-green-600 to-emerald-700 text-white font-bold px-6 rounded-r-lg hover:opacity-90 transition duration-300">
                                        <i class="fas fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                            
                            <!-- Share Buttons -->
                            <div>
                                <h4 class="font-bold text-gray-800 mb-3">Share on Social Media</h4>
                                <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
                                    <button onclick="shareOnFacebook()" 
                                            class="flex items-center justify-center bg-blue-600 text-white py-3 px-4 rounded-lg hover:bg-blue-700 transition duration-300">
                                        <i class="fab fa-facebook-f mr-2"></i> Facebook
                                    </button>
                                    
                                    <button onclick="shareOnWhatsApp()" 
                                            class="flex items-center justify-center bg-green-600 text-white py-3 px-4 rounded-lg hover:bg-green-700 transition duration-300">
                                        <i class="fab fa-whatsapp mr-2"></i> WhatsApp
                                    </button>
                                    
                                    <button onclick="shareOnTelegram()" 
                                            class="flex items-center justify-center bg-blue-400 text-white py-3 px-4 rounded-lg hover:bg-blue-500 transition duration-300">
                                        <i class="fab fa-telegram mr-2"></i> Telegram
                                    </button>
                                    
                                    <button onclick="shareOnTwitter()" 
                                            class="flex items-center justify-center bg-sky-500 text-white py-3 px-4 rounded-lg hover:bg-sky-600 transition duration-300">
                                        <i class="fab fa-twitter mr-2"></i> Twitter
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- How It Works -->
                    <div class="bg-white rounded-xl shadow-lg overflow-hidden animate__animated animate__fadeInLeft" style="animation-delay: 0.1s">
                        <div class="bg-gradient-to-r from-green-500 to-emerald-600 px-6 py-4">
                            <h3 class="text-xl font-bold text-white">
                                <i class="fas fa-question-circle mr-2"></i> How It Works
                            </h3>
                        </div>
                        <div class="p-6">
                            <div class="space-y-6">
                                <div class="flex items-start">
                                    <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mr-4 flex-shrink-0">
                                        <span class="text-blue-600 font-bold text-xl">1</span>
                                    </div>
                                    <div>
                                        <h4 class="font-bold text-gray-800 text-lg mb-2">Share Your Link</h4>
                                        <p class="text-gray-600">Share your unique referral link with friends, family, or on social media.</p>
                                    </div>
                                </div>
                                
                                <div class="flex items-start">
                                    <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center mr-4 flex-shrink-0">
                                        <span class="text-green-600 font-bold text-xl">2</span>
                                    </div>
                                    <div>
                                        <h4 class="font-bold text-gray-800 text-lg mb-2">They Join & Activate</h4>
                                        <p class="text-gray-600">Your referred friends register using your link and activate their account.</p>
                                    </div>
                                </div>
                                
                                <div class="flex items-start">
                                    <div class="w-12 h-12 bg-yellow-100 rounded-full flex items-center justify-center mr-4 flex-shrink-0">
                                        <span class="text-yellow-600 font-bold text-xl">3</span>
                                    </div>
                                    <div>
                                        <h4 class="font-bold text-gray-800 text-lg mb-2">You Earn Commission</h4>
                                        <p class="text-gray-600">You instantly earn <?php echo $referral_percentage; ?>% of their activation fee.</p>
                                    </div>
                                </div>
                                
                                <div class="flex items-start">
                                    <div class="w-12 h-12 bg-purple-100 rounded-full flex items-center justify-center mr-4 flex-shrink-0">
                                        <span class="text-purple-600 font-bold text-xl">4</span>
                                    </div>
                                    <div>
                                        <h4 class="font-bold text-gray-800 text-lg mb-2">Withdraw Earnings</h4>
                                        <p class="text-gray-600">Withdraw your earnings anytime to your preferred payment method.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Referral History -->
                    <div class="bg-white rounded-xl shadow-lg overflow-hidden animate__animated animate__fadeInLeft" style="animation-delay: 0.2s">
                        <div class="px-6 py-4 border-b bg-gradient-to-r from-blue-50 to-indigo-50">
                            <div class="flex items-center justify-between">
                                <h3 class="text-xl font-bold text-gray-800">
                                    <i class="fas fa-history mr-2"></i> Referral History
                                </h3>
                                <span class="text-gray-600 text-sm">
                                    Page <?php echo $page; ?> of <?php echo max(1, $total_pages); ?>
                                </span>
                            </div>
                        </div>
                        
                        <div class="p-6">
                            <?php if($referrals_result->num_rows > 0): ?>
                                <div class="overflow-x-auto">
                                    <table class="w-full">
                                        <thead>
                                            <tr class="bg-gray-50">
                                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Commission</th>
                                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Joined On</th>
                                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody class="divide-y divide-gray-200">
                                            <?php while($referral = $referrals_result->fetch_assoc()): 
                                                $status_color = $referral['status'] == 'paid' ? 'green' : 'yellow';
                                                $status_icon = $referral['status'] == 'paid' ? 'fa-check-circle' : 'fa-clock';
                                            ?>
                                            <tr class="hover:bg-gray-50 transition duration-300">
                                                <td class="px-4 py-4">
                                                    <div class="flex items-center">
                                                        <div class="w-10 h-10 bg-gradient-to-r from-blue-500 to-purple-500 rounded-full flex items-center justify-center text-white font-bold mr-3">
                                                            <?php echo strtoupper(substr($referral['username'], 0, 1)); ?>
                                                        </div>
                                                        <div>
                                                            <div class="font-medium text-gray-900"><?php echo $referral['username']; ?></div>
                                                            <div class="text-sm text-gray-500"><?php echo $referral['email']; ?></div>
                                                        </div>
                                                    </div>
                                                </td>
                                                
                                                <td class="px-4 py-4">
                                                    <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full bg-<?php echo $status_color; ?>-100 text-<?php echo $status_color; ?>-800">
                                                        <i class="fas <?php echo $status_icon; ?> mr-1"></i>
                                                        <?php echo ucfirst($referral['status']); ?>
                                                    </span>
                                                    <div class="text-xs text-gray-500 mt-1">
                                                        <?php echo $referral['is_active'] ? 'Account Active' : 'Account Inactive'; ?>
                                                    </div>
                                                </td>
                                                
                                                <td class="px-4 py-4">
                                                    <?php if($referral['bonus_amount']): ?>
                                                        <div class="text-lg font-bold text-green-600">
                                                            ৳<?php echo number_format($referral['bonus_amount'], 2); ?>
                                                        </div>
                                                        <div class="text-xs text-gray-500">
                                                            <?php echo $referral_percentage; ?>% Commission
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="text-sm text-gray-500">Pending</div>
                                                    <?php endif; ?>
                                                </td>
                                                
                                                <td class="px-4 py-4 text-sm text-gray-500">
                                                    <?php echo date('M d, Y', strtotime($referral['user_created'])); ?>
                                                </td>
                                                
                                                <td class="px-4 py-4 text-sm font-medium">
                                                    <button onclick="viewReferralDetails(<?php echo $referral['referred_id']; ?>)" 
                                                            class="text-blue-600 hover:text-blue-900 mr-3">
                                                        <i class="fas fa-eye"></i>
                                                    </button>
                                                    <?php if($referral['is_active']): ?>
                                                        <a href="https://t.me/<?php echo $referral['username']; ?>" 
                                                           target="_blank" 
                                                           class="text-green-600 hover:text-green-900">
                                                            <i class="fab fa-telegram"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endwhile; ?>
                                        </tbody>
                                    </table>
                                </div>
                                
                                <!-- Pagination -->
                                <?php if($total_pages > 1): ?>
                                <div class="mt-6 flex justify-center">
                                    <nav class="flex items-center space-x-2">
                                        <?php if($page > 1): ?>
                                            <a href="referrals.php?page=<?php echo $page-1; ?>"
                                               class="px-3 py-2 rounded-lg bg-white border border-gray-300 hover:bg-gray-50 transition duration-300">
                                                <i class="fas fa-chevron-left"></i> Previous
                                            </a>
                                        <?php endif; ?>
                                        
                                        <?php 
                                        $start = max(1, $page - 2);
                                        $end = min($total_pages, $page + 2);
                                        
                                        for($i = $start; $i <= $end; $i++): 
                                        ?>
                                            <a href="referrals.php?page=<?php echo $i; ?>"
                                               class="px-3 py-2 rounded-lg font-medium transition duration-300
                                                      <?php echo $i == $page ? 'bg-blue-600 text-white' : 'bg-white border border-gray-300 hover:bg-gray-50 text-gray-700'; ?>">
                                                <?php echo $i; ?>
                                            </a>
                                        <?php endfor; ?>
                                        
                                        <?php if($page < $total_pages): ?>
                                            <a href="referrals.php?page=<?php echo $page+1; ?>"
                                               class="px-3 py-2 rounded-lg bg-white border border-gray-300 hover:bg-gray-50 transition duration-300">
                                                Next <i class="fas fa-chevron-right"></i>
                                            </a>
                                        <?php endif; ?>
                                    </nav>
                                </div>
                                <?php endif; ?>
                                
                            <?php else: ?>
                                <div class="text-center py-12">
                                    <div class="w-24 h-24 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-6">
                                        <i class="fas fa-user-friends text-gray-400 text-3xl"></i>
                                    </div>
                                    <h3 class="text-2xl font-bold text-gray-700 mb-3">No Referrals Yet</h3>
                                    <p class="text-gray-600 mb-8 max-w-md mx-auto">
                                        You haven't referred anyone yet. Start sharing your referral link to earn commissions!
                                    </p>
                                    <button onclick="scrollToReferralLink()" 
                                            class="bg-gradient-to-r from-blue-600 to-indigo-600 text-white font-bold py-3 px-8 rounded-lg hover:from-blue-700 hover:to-indigo-700 transition duration-300">
                                        <i class="fas fa-share-alt mr-2"></i> Share Your Link
                                    </button>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <!-- Right Column - Stats & Leaderboard -->
                <div class="space-y-8">
                    <!-- Commission Calculator -->
                    <div class="bg-white rounded-xl shadow-lg overflow-hidden animate__animated animate__fadeInRight">
                        <div class="bg-gradient-to-r from-purple-500 to-pink-600 px-6 py-4">
                            <h3 class="text-xl font-bold text-white">
                                <i class="fas fa-calculator mr-2"></i> Commission Calculator
                            </h3>
                        </div>
                        <div class="p-6">
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-gray-700 text-sm font-bold mb-2">
                                        Activation Fee
                                    </label>
                                    <div class="relative">
                                        <span class="absolute left-4 top-1/2 transform -translate-y-1/2 text-gray-500 font-bold">৳</span>
                                        <input type="number" 
                                               id="activationFee"
                                               value="<?php echo $settings['activation_fee']; ?>"
                                               class="w-full pl-12 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-300"
                                               oninput="calculateCommission()">
                                    </div>
                                </div>
                                
                                <div>
                                    <label class="block text-gray-700 text-sm font-bold mb-2">
                                        Number of Referrals
                                    </label>
                                    <input type="number" 
                                           id="numReferrals"
                                           value="1" min="1" max="1000"
                                           class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition duration-300"
                                           oninput="calculateCommission()">
                                </div>
                                
                                <div class="pt-4 border-t">
                                    <div class="space-y-2">
                                        <div class="flex justify-between">
                                            <span class="text-gray-700">Commission Rate:</span>
                                            <span class="font-bold text-blue-600" id="commissionRate"><?php echo $referral_percentage; ?>%</span>
                                        </div>
                                        <div class="flex justify-between">
                                            <span class="text-gray-700">Total Activation Value:</span>
                                            <span class="font-bold" id="totalValue">৳0.00</span>
                                        </div>
                                        <div class="flex justify-between border-t pt-2">
                                            <span class="text-gray-700 font-bold">Your Earnings:</span>
                                            <span class="text-2xl font-bold text-green-600" id="yourEarnings">৳0.00</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Recent Earnings -->
                    <div class="bg-white rounded-xl shadow-lg overflow-hidden animate__animated animate__fadeInRight" style="animation-delay: 0.1s">
                        <div class="bg-gradient-to-r from-green-500 to-emerald-600 px-6 py-4">
                            <h3 class="text-xl font-bold text-white">
                                <i class="fas fa-money-bill-wave mr-2"></i> Recent Earnings
                            </h3>
                        </div>
                        <div class="p-6">
                            <?php if($recent_earnings->num_rows > 0): ?>
                                <div class="space-y-4">
                                    <?php while($earning = $recent_earnings->fetch_assoc()): ?>
                                    <div class="p-4 bg-green-50 rounded-lg">
                                        <div class="flex justify-between items-start mb-2">
                                            <span class="font-bold text-gray-800">
                                                ৳<?php echo number_format($earning['amount'], 2); ?>
                                            </span>
                                            <span class="px-2 py-1 bg-green-100 text-green-800 text-xs font-bold rounded">
                                                Commission
                                            </span>
                                        </div>
                                        <p class="text-gray-600 text-sm mb-2 truncate">
                                            <?php echo substr($earning['description'], 0, 50); ?>...
                                        </p>
                                        <p class="text-gray-500 text-xs">
                                            <i class="far fa-clock mr-1"></i>
                                            <?php echo date('M d, h:i A', strtotime($earning['created_at'])); ?>
                                        </p>
                                    </div>
                                    <?php endwhile; ?>
                                </div>
                            <?php else: ?>
                                <div class="text-center py-8">
                                    <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                                        <i class="fas fa-coins text-gray-400 text-2xl"></i>
                                    </div>
                                    <p class="text-gray-600">No commission earnings yet</p>
                                </div>
                            <?php endif; ?>
                            
                            <div class="mt-6">
                                <a href="transactions.php?type=referral_bonus" 
                                   class="block text-center text-green-600 hover:text-green-800 font-medium">
                                    <i class="fas fa-list mr-1"></i> View All Earnings
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Referral Leaderboard -->
                    <div class="bg-white rounded-xl shadow-lg overflow-hidden animate__animated animate__fadeInRight" style="animation-delay: 0.2s">
                        <div class="bg-gradient-to-r from-yellow-500 to-orange-600 px-6 py-4">
                            <h3 class="text-xl font-bold text-white">
                                <i class="fas fa-trophy mr-2"></i> Top Referrers
                            </h3>
                        </div>
                        <div class="p-6">
                            <?php if($leaderboard->num_rows > 0): ?>
                                <div class="space-y-3">
                                    <?php 
                                    $rank = 1;
                                    while($top = $leaderboard->fetch_assoc()): 
                                        $is_you = $top['username'] == $user['username'];
                                    ?>
                                    <div class="leaderboard-item flex items-center p-3 rounded-lg <?php echo $is_you ? 'bg-blue-50 border border-blue-200' : 'hover:bg-gray-50'; ?>">
                                        <div class="rank-badge <?php echo $rank <= 3 ? 'rank-' . $rank : 'bg-gray-200 text-gray-700'; ?> mr-3">
                                            <?php echo $rank; ?>
                                        </div>
                                        <div class="flex-1">
                                            <div class="flex items-center">
                                                <span class="font-medium text-gray-800 <?php echo $is_you ? 'text-blue-600 font-bold' : ''; ?>">
                                                    <?php echo $is_you ? 'You' : $top['username']; ?>
                                                </span>
                                                <?php if($is_you): ?>
                                                    <span class="ml-2 px-2 py-1 bg-blue-100 text-blue-700 text-xs font-bold rounded">
                                                        You
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                            <div class="flex justify-between text-sm text-gray-600">
                                                <span><?php echo $top['referral_count'] ?? 0; ?> referrals</span>
                                                <span class="font-bold text-green-600">৳<?php echo number_format($top['total_earnings'] ?? 0, 2); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                    <?php 
                                    $rank++;
                                    endwhile; 
                                    ?>
                                </div>
                                
                                <!-- Your Position -->
                                <div class="mt-6 pt-6 border-t">
                                    <?php
                                    $your_position = $conn->query("
                                        SELECT position FROM (
                                            SELECT u.id, u.username, COUNT(r.id) as referral_count,
                                            ROW_NUMBER() OVER (ORDER BY COUNT(r.id) DESC, SUM(r.bonus_amount) DESC) as position
                                            FROM users u
                                            LEFT JOIN referrals r ON u.id = r.referrer_id AND r.status = 'paid'
                                            WHERE u.is_active = TRUE
                                            GROUP BY u.id
                                        ) as ranked_users
                                        WHERE username = '{$user['username']}'
                                    ")->fetch_assoc();
                                    ?>
                                    <div class="text-center">
                                        <p class="text-gray-600 mb-2">Your Leaderboard Position</p>
                                        <div class="text-3xl font-bold text-blue-600">
                                            #<?php echo $your_position['position'] ?? 'N/A'; ?>
                                        </div>
                                    </div>
                                </div>
                                
                            <?php else: ?>
                                <div class="text-center py-8">
                                    <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
                                        <i class="fas fa-trophy text-gray-400 text-2xl"></i>
                                    </div>
                                    <p class="text-gray-600">No leaderboard data available</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Tips & Tricks -->
                    <div class="bg-gradient-to-r from-blue-500 to-indigo-600 rounded-xl shadow-lg p-6 text-white animate__animated animate__fadeInRight" style="animation-delay: 0.3s">
                        <h3 class="text-xl font-bold mb-4">
                            <i class="fas fa-lightbulb mr-2"></i> Tips for Success
                        </h3>
                        <div class="space-y-3">
                            <div class="flex items-start">
                                <i class="fas fa-check mt-1 mr-3"></i>
                                <p class="text-sm opacity-90">Share on social media groups</p>
                            </div>
                            <div class="flex items-start">
                                <i class="fas fa-check mt-1 mr-3"></i>
                                <p class="text-sm opacity-90">Create helpful content about the platform</p>
                            </div>
                            <div class="flex items-start">
                                <i class="fas fa-check mt-1 mr-3"></i>
                                <p class="text-sm opacity-90">Help referrals with activation process</p>
                            </div>
                            <div class="flex items-start">
                                <i class="fas fa-check mt-1 mr-3"></i>
                                <p class="text-sm opacity-90">Track your referrals regularly</p>
                            </div>
                            <div class="flex items-start">
                                <i class="fas fa-check mt-1 mr-3"></i>
                                <p class="text-sm opacity-90">Withdraw earnings to reinvest</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Referral Details Modal -->
    <div id="referralModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center p-4">
        <div class="bg-white rounded-2xl max-w-md w-full">
            <div class="p-4 border-b flex justify-between items-center">
                <h3 class="text-xl font-bold text-gray-800">Referral Details</h3>
                <button onclick="closeReferralModal()" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            <div id="referralContent" class="p-6">
                <!-- Content loaded via AJAX -->
            </div>
        </div>
    </div>
    
    <script>
    // Copy referral link
    function copyReferralLink() {
        const link = document.getElementById('referralLink');
        link.select();
        document.execCommand('copy');
        showNotification('Referral link copied to clipboard!', 'success');
    }
    
    // Copy referral code
    function copyReferralCode() {
        const code = document.getElementById('referralCode');
        code.select();
        document.execCommand('copy');
        showNotification('Referral code copied to clipboard!', 'success');
    }
    
    // Share functions
    function shareOnFacebook() {
        const link = encodeURIComponent(document.getElementById('referralLink').value);
        const text = encodeURIComponent('Join Project Sale using my referral link and earn money!');
        window.open(`https://www.facebook.com/sharer/sharer.php?u=${link}&quote=${text}`, '_blank');
    }
    
    function shareOnWhatsApp() {
        const link = encodeURIComponent(document.getElementById('referralLink').value);
        const text = encodeURIComponent('Join Project Sale using my referral link! ' + link);
        window.open(`https://wa.me/?text=${text}`, '_blank');
    }
    
    function shareOnTelegram() {
        const link = encodeURIComponent(document.getElementById('referralLink').value);
        const text = encodeURIComponent('Join Project Sale using my referral link!');
        window.open(`https://t.me/share/url?url=${link}&text=${text}`, '_blank');
    }
    
    function shareOnTwitter() {
        const link = encodeURIComponent(document.getElementById('referralLink').value);
        const text = encodeURIComponent('Join Project Sale using my referral link and earn money!');
        window.open(`https://twitter.com/intent/tweet?text=${text}&url=${link}`, '_blank');
    }
    
    // Commission calculator
    function calculateCommission() {
        const fee = parseFloat(document.getElementById('activationFee').value) || 0;
        const referrals = parseInt(document.getElementById('numReferrals').value) || 1;
        const rate = <?php echo $referral_percentage; ?>;
        
        const totalValue = fee * referrals;
        const earnings = totalValue * (rate / 100);
        
        document.getElementById('totalValue').textContent = '৳' + totalValue.toLocaleString();
        document.getElementById('yourEarnings').textContent = '৳' + earnings.toLocaleString();
    }
    
    // View referral details
    function viewReferralDetails(userId) {
        fetch('ajax/referral-details.php?id=' + userId)
            .then(response => response.text())
            .then(html => {
                document.getElementById('referralContent').innerHTML = html;
                document.getElementById('referralModal').classList.remove('hidden');
                document.getElementById('referralModal').classList.add('flex');
            })
            .catch(error => {
                console.error('Error:', error);
                showNotification('Failed to load referral details', 'error');
            });
    }
    
    function closeReferralModal() {
        document.getElementById('referralModal').classList.add('hidden');
        document.getElementById('referralModal').classList.remove('flex');
    }
    
    // Scroll to referral link
    function scrollToReferralLink() {
        document.getElementById('referralLink').scrollIntoView({ 
            behavior: 'smooth' 
        });
        document.getElementById('referralLink').select();
    }
    
    // Initialize calculator
    document.addEventListener('DOMContentLoaded', function() {
        calculateCommission();
        
        // Add animations
        const cards = document.querySelectorAll('.animate__animated');
        cards.forEach((card, index) => {
            setTimeout(() => {
                card.classList.add('animate__animated', 'animate__fadeIn');
            }, index * 100);
        });
        
        // Close modal when clicking outside
        document.addEventListener('click', function(event) {
            const modal = document.getElementById('referralModal');
            const modalContent = modal.querySelector('.bg-white');
            
            if(modal.classList.contains('flex') && !modalContent.contains(event.target) && !event.target.closest('button[onclick*="viewReferralDetails"]')) {
                closeReferralModal();
            }
        });
    });
    
    function showNotification(message, type) {
        const notification = document.createElement('div');
        notification.className = `fixed top-4 right-4 px-6 py-3 rounded-lg shadow-xl text-white font-bold z-50 animate__animated animate__fadeInRight ${type === 'success' ? 'bg-green-500' : 'bg-red-500'}`;
        notification.innerHTML = `
            <div class="flex items-center">
                <i class="fas ${type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle'} mr-3 text-xl"></i>
                <span>${message}</span>
            </div>
        `;
        document.body.appendChild(notification);
        
        setTimeout(() => {
            notification.classList.remove('animate__fadeInRight');
            notification.classList.add('animate__fadeOutRight');
            setTimeout(() => notification.remove(), 300);
        }, 3000);
    }
    </script>
</body>
</html>